require( "scripts/chocshopstyle.lua" );

local cp_closed = false;

kButtonX = 23;
kButtonY = 70;
kButtonYSpace = 35;
kButtonXSpace = 222;
kMaxUsers = 10;
dialogW = 491;
dialogH = 404;

-- Used to toggle on/off submit options
function ShowSubmitOptions( show )
	EnableWindow( "chooseplayer_delete_button", show );
	EnableWindow( "chooseplayer_ok_button", show );
	EnableWindow( "chooseplayer_edit_button", show );
end

-- Used to toggle on/off create options
function ShowCreateOptions( show )
	EnableWindow( "chooseplayer_new_button", show );
end

-- Used to add our group of buttons that represent the player names
function AddButtons( n )

	t = { SetStyle( ChoosePlayer_NameStyle ), BeginGroup() };

	for i = 0, n - 1 do
	
		row = i;
		column = 0;
		if( row > 4 ) then
			row = i - 5;
			column = 1;
		end
		
		table.insert( t,
			Button 
			{
				x			= kButtonX + (kButtonXSpace * column),
				y			= kButtonY + (kButtonYSpace * row),
				name		= "chooseplayer_button_"..i,
				label		= "",
				graphics	= {
					"ui/buttons/chooseplayer",
					"ui/buttons/chooseplayer_over"
				},
				
				RShrinkText
				{
					x		= 30,
					y		= 0,
					w		= 216 - 35,
					h		= 33,
					name	= "namefield",
					flags	= kHAlignLeft + kVAlignCenter
				},
			}
		);	
	end
	
	for i = 0, n - 1 do
	
		row = i;
		column = 0;
		if( row > 4 ) then
			row = i - 5;
			column = 1;
		end
		
		table.insert( t,
			Bitmap
			{
				x		= kButtonX + (kButtonXSpace * column),
				y		= kButtonY + (kButtonYSpace * row),
				name	= "chooseplayer_default_"..i,
				image	= "ui/buttons/chooseplayer",
			}
		);	
	end
	
	for i = 0, n - 1 do
		
		row = i;
		column = 0;
		if( row > 4 ) then
			row = i - 5;
			column = 1;
		end
		
		table.insert( t,
			Bitmap
			{
				x		= kButtonX + (kButtonXSpace * column) - 7,
				y		= kButtonY + (kButtonYSpace * row),
				image	= "gfx/choc_"..i
			}
		);
	end

	return Group(t);
end

-- Used to refresh the list of player choices
function UpdatePlayerChoices( curUser, numUsers, userTable )

	-- Toggles on/off the create options based on how many users we have
	if( numUsers >= kMaxUsers ) then
		ShowCreateOptions( false );
	else
		ShowCreateOptions( true );
	end

	-- Toggles on/off the submit options based on how many users we have
	if( numUsers == 0 ) then
		ShowSubmitOptions( false );
	else
		ShowSubmitOptions( true );
	end

	-- Toggles on all of the buttons that we have users for
	for i = 0, numUsers - 1 do
		SetNameField( "chooseplayer_button_"..i, userTable[ i+1 ].."          " );
		EnableWindow( "chooseplayer_button_"..i, true );
		EnableWindow( "chooseplayer_default_"..i, false );
	end

	-- Toggles off the rest of the buttons
	for i = numUsers, kMaxUsers do
		EnableWindow( "chooseplayer_button_"..i, false );
		EnableWindow( "chooseplayer_default_"..i, true );
	end

	-- Toggles the current user's button on
	if numUsers > 0 then
		SetButtonToggleState( "chooseplayer_button_"..curUser, true );
	end
end

MakeDialog
{
	name = "chooseplayer",
	
	VTintWindow
	{
	    x		= 0, 
	    y		= 0, 
	    w		= 800, 
	    h		= 600,
	    color	= Color( 0, 0, 0, 200 ),
	    time	= 200,
	    fade	= true
	},
	
	RBounceWindow
	{
		x			= 155,
		y			= -600 - dialogH - 10,
		w           = dialogW,
		h           = dialogH,
	    targetposx	= 155, 
	    targetposy	= 100,
	    bouncelen	= 200, 
	    bouncefunc	= "sincx",
		
		KSplit9Image {
		    x = 0,
		    y = 0,
		    w = dialogW,
		    h = dialogH,
		    image = "ui/backgrounds/split9_dialog",
		    x1 = 60,
		    x2 = 60,
		    y1 = 60,
		    y2 = 60,
		},
		
		TChoosePlayer
		{
			x = 0, 
			y = 0, 
			w = kMax, 
			h = kMax,
			
			---------------------------------------------- Title
			Text
			{
				x		= 0,
				y		= 30,
				w		= kMax,
				h		= kMax,
				font	= ChoosePlayer_HeaderFont,
				name	= "chooseplayer_title_text",
				flags	= kHAlignCenter + kVAlignTop,
				label	= "#<outline color='000000' size='1'>"..GetString( "chooseplayer_title" ).."</outline>"
			},
			
			---------------------------------------------- Players
			AddButtons( kMaxUsers );
			
			Bitmap{
	            x       = dialogW/2 - 95,
	            y       = kMax - 124,
	            image   = "ui/story/btn_trim_left",
	        },
	        Bitmap{
	            x       = dialogW/2 + 16,
	            y       = kMax - 124,
	            image   = "ui/story/btn_trim_left",
	            hflip   = true,
	        },
		
			---------------------------------------------- Edit
			SetStyle(CSOvalLightBlueButtonStyle);
			Button
			{
				x		= 79,
				y		= 280,
				name	= "chooseplayer_edit_button",
				type	= kPush,
				label	= "chooseplayer_edit",
				command =
					function()
						gEnterNameValue = GetSelectedUserName();
						name = DoModal( "scripts/entername.lua" );
						if( not( name == nil ) ) then
							SetCurrentUser( GetSelectedUserIndex() );
							ChangeCurrentUserName( name );
							SetPlayerChoices();
							SetWelcomeText();
						end
					end
			},
			
			---------------------------------------------- Ok
			SetStyle(CSOvalLightBlueButtonStyle);
			Button
			{
				x		= 189,
				y		= 310,
				--w		= 104,
				--h		= 68,
				name	= "chooseplayer_ok_button",
				label	= "app_ok",
				type	= kPush,
				default = true,
				command = 
					function()
					   -- if( not cp_closed ) then
						    --cp_closed = true;
						    PostMessage( CreateNamedMessage( kTintOff, "" ) );
						    DoTransition( kBounceBack );
				            SetCurrentUser( GetSelectedUserIndex() ); 
				            SetWelcomeText(); 
				            PopModal( 'chooseplayer' );
						--end
					end
				
			},
				
			---------------------------------------------- New
			SetStyle(CSOvalLightBlueButtonStyle);
			Button
			{
				x		= 189,
				y		= 242,
				--w		= 104,
				--h		= 68,
				name	= "chooseplayer_new_button",
				label	= "chooseplayer_new",
				type	= kPush,
				command =
					function()
						gEnterNameValue = "";
						name = DoModal( "scripts/entername.lua" );
						if( not( name == nil ) ) then
							CreateNewUser( name );
							SetPlayerChoices();
						end
					end
			},
				
			---------------------------------------------- Delete
			SetStyle(CSOvalLightBlueButtonStyle);
			Button
			{
				x		= 302,
				y		= 280,
				name	= "chooseplayer_delete_button",
				label	= "chooseplayer_delete",
				type	= kPush,
				command =
					function()
						result = DisplayDialog { "scripts/yesno.lua", body = "deleteplayer_body", title = "deleteplayer_title", width=350, height=250 };
						if( result == 'yes' ) then
							DeleteUser( GetSelectedUserIndex() );
							SetPlayerChoices();
						end
					end
			},
		},
	},
}